import QtQuick 2.12

Item {
    id: root
    signal requestView(int row)
    signal requestRemove(int row)
    anchors.left: parent.left
    anchors.right: parent.right
    implicitHeight: 50
    Rectangle {
        anchors.fill: parent
        color: index % 2 === 0 ? "lightgrey" : "darkgrey"
        Text {
            id: fNameLabel
            anchors.left: parent.left
            anchors.leftMargin: 6
            text: model.firstName
            font.pixelSize: parent.height * 0.8
        }
        Text {
            id: lNameLabel
            anchors.horizontalCenter: parent.horizontalCenter
            text: model.lastName
            font.pixelSize: parent.height * 0.8
        }
        Text {
            id: dobLabel
            anchors.right: rmButton.left
            anchors.rightMargin: 6
            text: model.dob
            font.pixelSize: parent.height * 0.8
        }
        MouseArea {
            id:ma
            anchors.fill: parent
            onClicked: root.requestView(index)
        }
        Button {
            id: rmButton
            anchors.right: parent.right
            anchors.rightMargin: 2
            height: parent.height - anchors.rightMargin; width: height
            text:"X"
            onClicked: console.log("Remove: " + index)
        }
    }
}
